function rntk = empericalrntk_weight_untied(x,xp,param,weights)

[m,T] = size(x);
Tp = T;
sigmaw = param.sigmaw;
sigmau = param.sigmau;
sigmav = param.sigmav;
sigmab = param.sigmab;
w = weights.w;
u = weights.u;
v = weights.v;
b = weights.b;
n = length(v);
% x
g = zeros(n,T);
h = zeros(n,T);
d = zeros(n,T);
g(:,1) = (sigmau/sqrt(m))*u(:,:,1)*x(:,1) + sigmab(:,1)*b(:,1);
h(:,1) = max(0,g(:,1));
d(:,1) = heaviside(g(:,1));
for t = 2:T
    g(:,t) = (sigmaw/sqrt(n))*w(:,:,t)*h(:,t-1) + (sigmau/sqrt(m))*u(:,:,t)*x(:,t) + sigmab*b(:,t);
    h(:,t) = max(0,g(:,t));
    d(:,t) = heaviside(g(:,t));
end
% xp
gp = zeros(n,Tp);
hp = zeros(n,Tp);
dp = zeros(n,Tp);
gp(:,1) = (sigmau/sqrt(m))*u(:,:,1)*xp(:,1) + sigmab*b(:,:,1);
hp(:,1) = max(0,gp(:,1));
dp(:,1) = heaviside(gp(:,1));
for t = 2:Tp
    gp(:,t) = (sigmaw/sqrt(n))*w(:,:,t)*hp(:,t-1) + (sigmau/sqrt(m))*u(:,:,t)*xp(:,t) + sigmab*b(:,:,t);
    hp(:,t) = max(0,gp(:,t));
    dp(:,t) = heaviside(gp(:,t));
end
% q
q = ones(n,T);
q(:,T) = (sigmav/sqrt(n))*diag(d(:,T))*v;
for t = (T-1):-1:1
    q(:,t) = (sigmaw/sqrt(n))*diag(d(:,t))*w(:,:,t)'*q(:,t+1);
end
% qp
qp = ones(n,Tp);
qp(:,Tp) = (sigmav/sqrt(n))*diag(dp(:,Tp))*v;
for t = (Tp-1):-1:1
    qp(:,t) = (sigmaw/sqrt(n))*diag(dp(:,t))*w(:,:,t)'*qp(:,t+1);
end
% gw
gw = zeros(n,n,T);
for t = 2:T
   gw(:,:,t) = (sigmaw/sqrt(n))*q(:,t)*h(:,t-1)';
end
gu = zeros(n,m,T);
for t = 1:T
    gu(:,:,t) = (sigmau/sqrt(m))*q(:,t)*x(:,t)';
end
gb = zeros(n,T);
for i = 1:T
    gb(:,T) = sigmab*q(:,t);
end
gv = (sigmav/sqrt(n))*h(:,T);
% gpw
% gw
gpw = zeros(n,n,T);
for t = 2:T
   gpw(:,:,t) = (sigmaw/sqrt(n))*qp(:,t)*hp(:,t-1)';
end
gpu = zeros(n,m,T);
for t = 1:T
    gpu(:,:,t) = (sigmau/sqrt(m))*qp(:,t)*xp(:,t)';
end
gpb = zeros(n,T);
for i = 1:T
    gpb(:,T) = sigmab*qp(:,t);
end
gpv = (sigmav/sqrt(n))*hp(:,T);

rntk = 0;
for i = 1:T
   rntk = rntk + trace(gw(:,:,i)'*gpw(:,:,i)) + trace(gu(:,:,i)'*gpu(:,:,i)) + trace(gb(:,i)'*gpb(:,i));
end
rntk = rntk + gv'*gpv;

end

